<?php
require_once 'config.php';

$token = $_GET['token'] ?? '';
if ($token === '') {
    echo "Token inválido.";
    exit;
}

$order = findOrderByToken($token);
if (!$order) {
    echo "Orden no encontrada o token inválido.";
    exit;
}

if ($order['status'] !== 'paid') {
    echo "La orden aún no está pagada.";
    exit;
}

$today = date('Y-m-d');
if ($today > $order['end_date']) {
    echo "La licencia ha expirado. Vigencia hasta " . e($order['end_date']);
    exit;
}

$beat = getBeatById($order['beat_id']);
if (!$beat) {
    echo "Beat no encontrado.";
    exit;
}

$filePath = $beat['full_url']; // ruta relativa desde el docroot

if (!file_exists($filePath)) {
    echo "Archivo no encontrado en el servidor (" . e($filePath) . ").";
    exit;
}

// Forzar descarga
$filename = basename($filePath);
header('Content-Description: File Transfer');
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($filePath));
readfile($filePath);
exit;
