<?php
require_once 'config.php';

if (!isset($_SESSION['cart'])) {
    header('Location: beats.php');
    exit;
}

$cart = $_SESSION['cart'];
$beat = getBeatById($cart['beat_id']);
$license = getLicenseByKey($cart['license_key']);
$price = $cart['price'];

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name  = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');

    if ($name === '' || $email === '') {
        $error = 'Por favor completa tu nombre y correo.';
    } else {
        // Aquí normalmente iría la integración con Wompi/PayU/Stripe/etc.
        // En este demo simulamos un pago exitoso.

        $orderId = uniqid('ord_');
        $startDate = date('Y-m-d');
        $endDate   = date('Y-m-d', strtotime('+1 year'));
        $token     = bin2hex(random_bytes(16));

        $_SESSION['orders'][$orderId] = [
            'customer_name'  => $name,
            'customer_email' => $email,
            'beat_id'        => $beat['id'],
            'license_key'    => $cart['license_key'],
            'price'          => $price,
            'status'         => 'paid', // en real: esperar confirmación de la pasarela
            'start_date'     => $startDate,
            'end_date'       => $endDate,
            'download_token' => $token,
            'created_at'     => date('Y-m-d H:i:s'),
        ];

        // opcional: limpiar carrito
        unset($_SESSION['cart']);

        header('Location: success.php?order=' . urlencode($orderId));
        exit;
    }
}

require_once 'header.php';
?>
<div class="card">
    <div class="card-header">
        <div>
            <div class="card-title">Checkout (demo)</div>
            <div class="meta">
                <span><?php echo e($beat['title']); ?></span>
                <span><?php echo e($license['name']); ?></span>
            </div>
        </div>
        <div class="price-tag">
            $<?php echo number_format($price, 2); ?>
        </div>
    </div>

    <div class="alert alert-info">
        Este es un <strong>pago de prueba</strong>. En un entorno real, aquí redirigirías a Wompi/PayU/Stripe
        y, tras la confirmación, crearías la licencia exactamente como lo hace este demo.
    </div>

    <?php if ($error): ?>
        <div class="alert alert-danger"><?php echo e($error); ?></div>
    <?php endif; ?>

    <form method="post">
        <div class="form-group">
            <label for="name">Nombre completo</label>
            <input class="form-control" type="text" id="name" name="name"
                   value="<?php echo e($_POST['name'] ?? ''); ?>" required>
        </div>
        <div class="form-group">
            <label for="email">Correo electrónico</label>
            <input class="form-control" type="email" id="email" name="email"
                   value="<?php echo e($_POST['email'] ?? ''); ?>" required>
        </div>
        <div style="display:flex; justify-content:flex-end; gap:8px; margin-top:8px;">
            <a href="cart.php" class="btn btn-ghost">Volver</a>
            <button type="submit" class="btn btn-primary">
                Pagar ahora (simulado)
            </button>
        </div>
    </form>
</div>
<?php
require_once 'footer.php';
