<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: beats.php');
    exit;
}

$beatId  = isset($_POST['beat_id']) ? (int)$_POST['beat_id'] : 0;
$licenseKey = isset($_POST['license']) ? $_POST['license'] : null;

$beat = getBeatById($beatId);
$license = getLicenseByKey($licenseKey);

if (!$beat || !$license) {
    echo "Datos inválidos";
    exit;
}

$price = getLicensePrice($beat, $licenseKey);

// Guardamos “carrito” en sesión
$_SESSION['cart'] = [
    'beat_id' => $beatId,
    'license_key' => $licenseKey,
    'price' => $price,
];

require_once 'header.php';
?>
<div class="card">
    <div class="card-header">
        <div>
            <div class="card-title">Resumen de licencia</div>
            <div class="meta">
                <span>Beat: <?php echo e($beat['title']); ?></span>
                <span>Licencia: <?php echo e($license['name']); ?></span>
            </div>
        </div>
        <div class="price-tag">
            Total: $<?php echo number_format($price, 2); ?>
        </div>
    </div>

    <div class="alert alert-info">
        <strong>Contrato (resumen):</strong><br>
        • Licencia no exclusiva (excepto en modalidad Exclusiva).<br>
        • Vigencia de 1 año a partir de la fecha de compra.<br>
        • Permitido usar el beat según la modalidad seleccionada (Básica/Premium/Exclusiva).<br>
        • No se permite revender ni redistribuir el beat en su forma original.
    </div>

    <div class="contract-box" style="margin-bottom:10px;">
        Para un entorno real, este texto debería ser reemplazado por un contrato revisado por un abogado, detallando:
        derechos, territorios, usos permitidos, créditos, reclamaciones, etc.
    </div>

    <form action="checkout.php" method="post">
        <div class="form-group">
            <label>
                <input type="checkbox" name="accept_terms" value="1" required>
                Confirmo que he leído y acepto el contrato de licencia de 1 año asociado a esta modalidad.
            </label>
        </div>
        <div style="display:flex; justify-content:flex-end; gap:8px;">
            <a href="beat.php?id=<?php echo $beat['id']; ?>" class="btn btn-ghost">Cambiar licencia</a>
            <button type="submit" class="btn btn-primary">Continuar al pago (demo)</button>
        </div>
    </form>
</div>
<?php
require_once 'footer.php';
