<?php
require_once 'config.php';
require_once 'header.php';

$allBeats = getAllBeats();
?>
<div class="hero">
    <div class="hero-text">
        <h1>Catálogo de beats.</h1>
        <p>Escucha el demo, elige una licencia (Básica, Premium o Exclusiva) y descarga el beat completo tras el pago (simulado).</p>
    </div>
    <div class="hero-pill">
        Tienda de beats • PHP puro
    </div>
</div>

<div class="card-grid">
    <?php foreach ($allBeats as $beat): ?>
        <div class="card">
            <div class="card-header">
                <div>
                    <div class="card-title"><?php echo e($beat['title']); ?></div>
                    <div class="meta">
                        <span><?php echo e($beat['genre']); ?></span>
                        <span><?php echo e($beat['bpm']); ?> BPM</span>
                    </div>
                </div>
                <div class="price-tag">
                    desde $<?php echo number_format($beat['base_price'], 2); ?>
                </div>
            </div>
            <div class="description">
                <?php echo e($beat['description']); ?>
            </div>
            <audio controls preload="none">
                <source src="<?php echo e($beat['demo_url']); ?>" type="audio/mpeg">
                Tu navegador no soporta el audio.
            </audio>
            <div style="display:flex; justify-content:space-between; align-items:center; gap:8px; margin-top:6px;">
                <span class="pill">Demo (puedes usar versión con marca de agua)</span>
                <a class="btn btn-primary" href="beat.php?id=<?php echo $beat['id']; ?>">
                    Ver licencias
                </a>
            </div>
        </div>
    <?php endforeach; ?>
</div>
<?php
require_once 'footer.php';
