<?php
require_once 'config.php';

$orderId = $_GET['order'] ?? '';
$order   = $_SESSION['orders'][$orderId] ?? null;

if (!$order) {
    echo "Orden no encontrada.";
    exit;
}

$beat    = getBeatById($order['beat_id']);
$license = getLicenseByKey($order['license_key']);

require_once 'header.php';
?>
<div class="card">
    <div class="card-header">
        <div>
            <div class="card-title">¡Gracias por tu compra!</div>
            <div class="meta">
                <span>Orden: <?php echo e($orderId); ?></span>
                <span><?php echo e($order['customer_email']); ?></span>
            </div>
        </div>
        <div class="price-tag">
            $<?php echo number_format($order['price'], 2); ?>
        </div>
    </div>

    <p class="description">
        Has adquirido <strong><?php echo e($license['name']); ?></strong> para el beat
        <strong><?php echo e($beat['title']); ?></strong>.
    </p>

    <div class="alert alert-info">
        <strong>Licencia de 1 año:</strong><br>
        Vigente desde <strong><?php echo e($order['start_date']); ?></strong> hasta
        <strong><?php echo e($order['end_date']); ?></strong> (ambas fechas inclusive).
    </div>

    <p class="description">
        Puedes descargar el archivo completo del beat a continuación. En un entorno real, también recibirías
        esta información por correo con el contrato de licencia adjunto o enlazado.
    </p>

    <div style="display:flex; justify-content:flex-start; gap:8px; margin-top:8px;">
        <a class="btn btn-primary"
           href="download.php?token=<?php echo urlencode($order['download_token']); ?>">
            Descargar beat completo
        </a>
    </div>
</div>
<?php
require_once 'footer.php';
