<?php
require_once 'config.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$beat = getBeatById($id);

if (!$beat) {
    http_response_code(404);
    echo "Beat no encontrado";
    exit;
}

require_once 'header.php';
?>
<div class="card" style="margin-bottom:16px;">
    <div class="card-header">
        <div>
            <div class="card-title"><?php echo e($beat['title']); ?></div>
            <div class="meta">
                <span><?php echo e($beat['genre']); ?></span>
                <span><?php echo e($beat['bpm']); ?> BPM</span>
            </div>
        </div>
        <div class="price-tag">
            base $<?php echo number_format($beat['base_price'], 2); ?>
        </div>
    </div>
    <div class="description">
        <?php echo e($beat['description']); ?>
    </div>
    <audio controls preload="none">
        <source src="<?php echo e($beat['demo_url']); ?>" type="audio/mpeg">
        Tu navegador no soporta el audio.
    </audio>

    <form action="cart.php" method="post" style="margin-top:12px;">
        <input type="hidden" name="beat_id" value="<?php echo $beat['id']; ?>">
        <div class="license-options">
            <?php foreach ($licenseTypes as $key => $lic): ?>
                <?php $price = getLicensePrice($beat, $key); ?>
                <label>
                    <span>
                        <input type="radio" name="license" value="<?php echo e($key); ?>" <?php echo $key === 'basic' ? 'checked' : ''; ?>>
                        <strong><?php echo e($lic['name']); ?></strong>
                        <small><?php echo e($lic['short']); ?></small>
                    </span>
                    <span>$<?php echo number_format($price, 2); ?></span>
                </label>
            <?php endforeach; ?>
        </div>

        <div class="contract-box">
            Al continuar, la licencia tendrá una duración de <strong>1 año</strong> desde la fecha de compra.
            Podrás ver un resumen del contrato en el siguiente paso.
        </div>

        <div style="margin-top:10px; display:flex; gap:8px; justify-content:flex-end;">
            <a href="index.php" class="btn btn-ghost">Volver</a>
            <button type="submit" class="btn btn-primary">
                Continuar al contrato
            </button>
        </div>
    </form>
</div>
<?php
require_once 'footer.php';
